@echo off

if "%OS%"=="Windows_NT" setlocal
if "%OS%"=="WINNT" setlocal

if "%OS%"=="Windows_NT" set LD_HOME=%~dp0
if "%OS%"=="WINNT" set LD_HOME=%~dp0

if "%LD_HOME:~-1%"=="\" set LD_HOME=%LD_HOME:~0,-1%

rem Setup logs directory
set LD_LOGS=%LD_HOME%\logs
set ld_logs_path=%LD_LOGS:\=/%

if exist "%LD_LOGS%" goto livedataSetup
mkdir "%LD_LOGS%"

:livedataSetup

set LD_TEMP=%LD_HOME%\temp
set LD_MAVEN_LOCAL_REPOSITORY=%LD_TEMP%\maven

for /F "eol=# tokens=2,2 delims==" %%i in ('findstr /r /c:"^\s*user=" "%LD_HOME%\livedata.properties"') do set LD_USER=%%i
for /F "eol=# tokens=2,2 delims==" %%i in ('findstr /r /c:"^\s*password=" "%LD_HOME%\livedata.properties"') do set LD_PASSWORD=%%i
for /F "eol=# tokens=2,2 delims==" %%i in ('findstr /r /c:"^\s*prefix=" "%LD_HOME%\livedata.properties"') do set LD_PREFIX=%%i
for /F "eol=# tokens=2,2 delims==" %%i in ('findstr /r /c:"^\s*version=" "%LD_HOME%\livedata.properties"') do set LD_VERSION=%%i

if "%LD_VERSION%"=="" set LD_VERSION="RELEASE"

if "%LD_PREFIX%"=="" goto noProfile
set LD_MAVEN_LOCAL_REPOSITORY=%LD_TEMP%\%LD_PREFIX%maven
:noProfile

set MAVEN_HOME=%LD_HOME%\maven
set MAVEN_OPTS=%MAVEN_OPTS% ^
  -Dmaven.repo.local="%LD_MAVEN_LOCAL_REPOSITORY%" ^
  -Doracle.jdbc.Trace=true ^
  -XX:+HeapDumpOnOutOfMemoryError ^
  -Xmx1024m ^
  -Dlogback.configurationFile="%LD_HOME%\conf\logback.xml" ^
  -Djdk.http.auth.tunneling.disabledSchemes="" ^
  -Dcom.revere.logs.dir="%LD_HOME%\logs" ^
  -Dcom.revere.admcfg.dir="%LD_HOME%" ^
  -Dld.dist.version="3.25.5" ^
  -Dcom.revere.ld.tempDirectory="%LD_TEMP%" ^
  -Dcom.revere.ld.client.home="%LD_HOME%" ^
  -Dld.prefix="%LD_PREFIX%"

call "%MAVEN_HOME%\bin\mvn" ^
  -U -s "%LD_HOME%\conf\settings.xml" ^
  -Dartifact="com.revere.ld:ld-client2:%LD_VERSION%" ^
  -DmainClass="com.revere.ld.client.LdClient" ^
  com.revere.jshell:jshell-maven-plugin:exec-main %*

if "%OS%"=="Windows_NT" endlocal & set ERROR_CODE=%ERROR_CODE%
if "%OS%"=="WINNT" endlocal & set ERROR_CODE=%ERROR_CODE%
